# Supplementary Material: ReCoDe

This supplementary material contains a video presentation, and the code for experiments presented in our submission.

## Folder Structure

- `ReCoDe_supplementary_video.mp4` - 3 minute video introducing our paper. Contains experiment footage.

- `code/`
    - `configs/`: Contains YAML configuration files for the experiment, tasks, algorithm (MAPPO), and models (GNNs).
    - `experimental_scenarios/`: Contains the Python implementations for the different multi-agent environments and their corresponding task definitions.
        - `*_env.py`: Environment logic and dynamics for each scenario.
        - `*_task.py`: Task definitions compatible with the BenchMARL framework.
    - `train.py`: The main script to run training experiments.
    - `utils.py`: Utility functions, including a helper to run and visualize scenarios.
    - `RVO.py`: Implementation of Reciprocal Velocity Obstacles (RVO) used in some scenarios.
    - `setup.py`: Script for setting up the Python environment and installing dependencies.
    - `README.md`: This file.

## Dependencies and Setup

All required Python packages and their versions are listed in `setup.py`. To install the dependencies, navigate to the `supplementary_material` directory and run:

```bash
pip install -e .
```

This will install the package in editable mode and fetch dependencies from `setup.py`, including those from Git repositories (BenchMARL and VMAS).

## How to Run the Code

Training is initiated via the `train.py` script, located in the `supplementary_material` directory.

```bash
cd supplementary_material
python train.py
```

### Selecting a Scenario

To choose which scenario to train on, you need to modify the `mode` variable within `train.py`.
Open `supplementary_material/train.py` and find the section:

```python
# What task are we training?
# Modify the line below to choose a different scenario to run.
# For example, to run the connectivity environment, set: mode = USE_CONNECTIVITY_ENV
mode = USE_WAYPOINT_ENV # Or USE_SENSORCOVERAGE_ENV, etc.
```

Change `mode = USE_WAYPOINT_ENV` to one of the other defined constants:
- `USE_CONNECTIVITY_ENV`
- `USE_NARROWCORRIDOR_ENV`
- `USE_WAYPOINT_ENV`
- `USE_SENSORCOVERAGE_ENV`

Each of these modes will load the corresponding task configuration from the `configs/` directory (e.g., `configs/waypoint_task_config.yaml`).

### Configuration Files

- **Experiment Configuration**: `configs/experiment_config.yaml` controls general training parameters like learning rates, batch sizes, evaluation frequency, and logging (e.g., `project_name` for wandb).
- **Task Configurations**: Files like `configs/sensorcoverage_task_config.yaml` define scenario-specific parameters (e.g., number of agents, max steps, control type).
- **Algorithm Configuration**: `configs/mappo_conf.yaml` defines parameters for the MAPPO algorithm.
- **Model Configurations**: `configs/actor_gnn.yaml` and `configs/critic_gnn.yaml` define the architecture for the GNN models used by the policy and critic.

### Visualizing Scenarios

Many of the `*_env.py` files (located in `experimental_scenarios/`) contain an `if __name__ == "__main__":` block. You can run these files directly to get a quick visual demonstration of the environment with random actions or simple scripted behavior. For example:

```bash
cd supplementary_material
python experimental_scenarios/sensorcoverage_env.py
```

This uses the `use_vmas_env` function from `utils.py`. Changing agent_control_type showcases different behaviors, though it's not always supported.

## Implemented Scenarios

The following multi-agent scenarios are implemented:

1.  **Sensor Coverage** (`sensorcoverage_env.py`, `sensorcoverage_task.py`):
    Agents (sensors) must position themselves to cover a set of randomly placed goals (points of interest) while maintaining connectivity and avoiding collisions. 

2.  **Connectivity** (`connectivity_env.py`, `connectivity_task.py`):
    Agents aim to move from a starting region to a target region while maintaining network connectivity and avoiding obstacles and collisions. The corridor is narrow, forcing agents to coordinate.

3.  **Narrow Corridor** (`narrowcorridor_env.py`, `narrowcorridor_task.py`):
    Two teams of agents navigate a narrow passage and must bypass each other. 

4.  **Waypoint Navigation** (`waypoint_env.py`, `waypoint_task.py`):
    Agents must navigate to individually assigned waypoints while avoiding collisions with each other. 

Each scenario can be configured via its respective YAML file in the `configs/` directory to change parameters such as the number of agents, obstacles, and the specific control type being used (e.g., `QP_CONTROL_CONSTRAINT` for the proposed method--though of course it must be *trained* to be used properly).