import librosa
import librosa.display
import matplotlib.pyplot as plt
import numpy as np

# 加载音频文件
audio_path = 'ffb86d3c_nohash_2.wav'  # 替换为你的音频文件路径
y, sr = librosa.load(audio_path, sr=None)  # 加载音频文件，sr=None表示使用原始采样率

# 计算短时傅里叶变换 (STFT)
D = librosa.stft(y)
# 转换为幅度
S = np.abs(D)
# 转换为对数尺度
S_db = librosa.amplitude_to_db(S, ref=np.max)

# 绘制热力图
plt.figure(figsize=(20, 4))
librosa.display.specshow(S_db, sr=sr, x_axis='time', y_axis='hz', cmap='coolwarm')
plt.colorbar(format='%+2.0f dB')
plt.title('STFT Magnitude (dB)')
plt.xlabel('Time')
plt.ylabel('Frequency')
plt.tight_layout()
plt.savefig("STFT.png",dpi=500)
plt.show()