import librosa
import librosa.display
import matplotlib.pyplot as plt
import numpy as np

# 加载音频文件
audio_path = 'ffb86d3c_nohash_2.wav'  # 替换为你的音频文件路径
y, sr = librosa.load(audio_path, sr=None)  # 加载音频文件，sr=None表示使用原始采样率

# 绘制波形
plt.figure(figsize=(20, 4))
librosa.display.waveshow(y, sr=sr)
plt.title('Audio Waveform')
plt.xlabel('Time (seconds)')
plt.ylabel('Amplitude')
plt.savefig("wav.png",dpi=500)
plt.show()