import torch
import matplotlib.pyplot as plt
import numpy as np
x = torch.randn(1000).cuda()  # 生成一个包含1000个随机值的张量

# 设置均值和标准差
mean = 1  # 自定义均值
std_dev = 0.1  # 自定义标准差

# 根据公式生成自定义噪声
noise_custom = mean + std_dev * torch.randn_like(x).cuda()

# 将噪声张量从CUDA转移到CPU，并转换为NumPy数组进行绘图
noise_custom_cpu = noise_custom.cpu().numpy()

# 绘制直方图
plt.figure(figsize=(8, 6))
plt.hist(noise_custom_cpu, bins=50, density=True, alpha=0.6, color='g')

# 设置图形标题和标签
plt.title(f'Noise Distribution: mean={mean}, std_dev={std_dev}')
plt.xlabel('Value')
plt.ylabel('Density')

# 显示图形
plt.show()