function [pert, C21, all_T12, all_C21] = HOPE(M, N, options, corr_true)
%% get number of nodes
n1 = M.n;
n2 = N.n;
num = n1;
if n1 > n2
    num = n2;
end
if nargout > 2, all_T12 = {}; all_C21 = {}; end

adj1 = sparse(M.adj);
adj2 = sparse(N.adj);

%% params
max_T_o = 1;
max_T = 1;
max_F = 8;

%% neigborhoods
D1 = cell(max_F);
D2 = cell(max_F);
for i=1:max_F
    D1{i} = build_witnesses(adj1, n1, i);
    D2{i} = build_witnesses(adj2, n2, i);
end

%% initialize map with shot
T12 = knnsearch(N.shots, M.shots,'NSMethod','kdtree');
pert = sparse(T12, 1:length(T12), 1, n2, n1);
if nargout > 2, all_T12{end+1} = pert; all_C21{end+1} = 0;end
C21 = 0;

%% refining params
MA = full(diag(M.Phi.A));
e = zeros(num,1);
R_max = max(max(N.distances));
th = linspace(100,0.2, 10); 

%% smoothness, continuity and global accuracy
for kk = 1:60       
    DD1 = cell(n1,1);
    DD2 = cell(n2,1);
    idx = cell(num,1);
    ee = zeros(num,1);
    good = 1:num;
    % goodF = corr_true(good);
    D1T = M.distances(good,good); 
    D2T = N.distances(T12(good),T12(good));
    for i = 1:length(good)
        idx{i} = find(D1T(:,i) ~= 0);
        DD1{i} = D1T(idx{i},i);
        DD2{i} = D2T(idx{i},i);
        DD2{i}(DD2{i}==0) = R_max;
        r = max(DD1{i});
        ee(i) = sum(((abs(DD1{i}-DD2{i}))/r).*MA(idx{i}))/sum(MA(idx{i}));        
    end
    e(good)=ee; 
    if kk<=length(th)
        landmarks = find(e<th(kk));
    else
        landmarks = find(e<th(end));
    end

    size_L = length(landmarks);
    bad = setdiff(1:n1, landmarks);
    size_b = length(bad);    

    % fprintf("[GLOBAL] iter: %i, num_lmks: %i, num_bad: %i\n", kk, size_L, size_b);
    if size_b > 0  
        cost = D2{max_T}*(pert*D1{max_T}(:, bad)) ;  
        % cost2 = D2{2}*(pert*D1{2}(:, bad)) ;  
        pert = greedy_match(cost);
        [idx2, idx] = find(pert);
        bad = bad(idx);       
        T12(bad) = idx2;         

        max_T = max_T + 1;
        if max_T > max_F
            max_T = max_T_o;
        end        

        pert = sparse(T12, 1:length(T12), 1, n2, n1);
    end

    if nargout > 2, all_T12{end+1} = pert; all_C21{end+1} = C21;end
end
