import numpy as np
from dmi import OrthogonalMatchingPursuit

# Set random seed for reproducibility
np.random.seed(42)

# Define dimensions
N = 50  # Number of items
D = 128  # Embedding dimension
max_length = 10  # Number of items to select

# Generate random kernel matrix (N x N)
kernel_matrix = np.random.rand(N, N).astype(np.float64)

# Generate random scoring embedding matrix (N x D)
emb_mat = np.random.rand(N, D).astype(np.float64)

# Instantiate the OrthogonalMatchingPursuit class
omp = OrthogonalMatchingPursuit(
    reward_mat=kernel_matrix, 
    emb_mat=emb_mat, 
    process_reward_args={'method': 'flat'}
)

# Run the selection
selected_items = omp.compute_selection(max_length)
print("Selected items:", selected_items)