# Robust Self-Supervised Learning with Lie Groups

## Installation
`pip install -f https://download.pytorch.org/whl/torch_stable.html -e .`

To record the current environment: `pip freeze --exclude-editable > requirements.txt`

## Testing
To run tests (excluding slow tests): `python -m pytest tests/`

To run all tests (including slow tests): `python -m pytest --runslow tests/`


## Launch Experiments

`python train_classifier.py -m model=[] dataset=[]`

You can optionally add notes about a run `notes='exploring new learning rate'`

See `config/` for a list of model and dataset options for reproducing experiments.


## Render Objects
To generate Shapes views:
* `cd datasets/shapes`
* `python generate_shapes.py --count 4`

 Be sure to install blender following the steps below. 

To render a single Shapes object as a png:

* `cd datasets/shapes`
* `blender --background -noaudio --python render.py` 

### Blender Installation

In your homedirectory, 

1. `wget https://download.blender.org/release/Blender3.0/blender-3.0.0-linux-x64.tar.xz`
2. `tar -xf blender-3.0.0-linux-x64.tar.xz`

If you need third party Python packages (such as matplot lib), be sure to add the desired conda environment to `datasets/shapes/render.py`
