"""
Contains off the shelf object detector
"""

import pytorch_lightning as pl
import torch


class MobileNetv2(pl.LightningModule):
    """Pretrained MobileNetv2 object detector.
    See https://pytorch.org/hub/pytorch_vision_mobilenet_v2/
    """

    def __init__(self):
        super().__init__()
        self.model = torch.hub.load(
            "pytorch/vision:v0.10.0", "mobilenet_v2", pretrained=True
        )

    def forward(self, x):
        pass
