from experiment.utils import check_json
from llm import gen, get_model, set_model, set_log

def direct(question: str):
    instruction = """
        Solve the following problem step by step:
        {question}
        
        Please extend your reasoning process as much as possible; the longer the chain of thought, the better.

    """
    instruction = "{question}"
    formatter = "Last step, enclose the answer within \\boxed{{}} (pure number without units and explanations)"
    instruction += formatter
    prompt = instruction.format(question=question)
    return prompt

def multistep(question: str):
    instruction = """
        Solve the following problem step by step:
        {question}
        
        Please extend your reasoning process as much as possible; the longer the reasoning process, the better.
        
    """
    formatter = "Last step, enclose the answer within \\boxed{{}} (pure number without units and explanations)"
    instruction += formatter
    prompt = instruction.format(question=question)
    return prompt

def decompose():
    instruction = """
        Decompose the previous reasoning trajectory into a series of sub-questions or thoughts.

        Instructions:
        1. Each sub-question or thought should list its other sub-questions or thoughts' indexes it depends (0-based, can be an empty list)
        2. Dependencies are defined as information needed in sub-question or thought that:
           - Does NOT come directly from the original question
           - MUST come from previous sub-questions or thoughts
    """
    return instruction

def contract():
    instruction = """
        Generate a simplified intermediate form of the original question based on the previous sub-questions or thoughts step by step.
        
        The previous sub-questions or thoughts with marked dependencies actually form a directed acyclic graph (DAG), where nodes whose dependencies is empty list can be regarded as independent sub-questions or thoughts.
        
        The simplified question must be:
        1. self-contained: The simplified question's description must contain all information needed to solve itself, without requiring additional information from the original question or reasoning trajectory
        2. test-time reduced: The simplified question must require fewer reasoning steps compared to the original question (these steps are reduced because these solved independent sub-problems or thoughts become known conditions in the simplified question or excluded as incorrect explorations)
        
    """
    formatter = "Last step, enclose the question within <question></question> tags"
    instruction += formatter
    return instruction

def ensemble(question: str, solutions: list):
    instruction = """
        Here is the original problem:
        {question}

        Here are some reference solutions:
        {solutions}
        
        Ensemble the best answer to the original problem from the solutions step by step:
    """
    formatter = "Last step, enclose the answer within \\boxed{{}} (pure number without units and explanations)"
    instruction += formatter
    
    solutions_str = ""
    for i, solution in enumerate(solutions):
        solutions_str += f"solution {i}: {solution}\n"
    prompt = instruction.format(question=question, solutions=solutions_str)
    return prompt

def label(solution):
    instruction = """
        Decompose the previous reasoning trajectory into a series of sub-questions or thoughts.

        Instructions:
        1. Each sub-question or thought should list its other sub-questions or thoughts' indexes it depends (0-based, can be an empty list)
        2. Dependencies are defined as information needed in sub-question or thought that:
           - Does NOT come directly from the original question
           - MUST come from previous sub-questions or thoughts

        The reasoning trajectory is: 
        {solution}

        Format your response as the following JSON objects:
        {{
            "thoughts":
                [
                    {{"thought_0": "<the first thought>", "dependencies": [indexes of thought_0 dependencies], "answer": "<give your answer of thought_0>"}},
                    {{"thought_1": "<the second thought>", "dependencies": [indexes of thought_1 dependencies], "answer": "<give your answer of thought_1>"}},
                    ...
                ]
        }}
"""
    return instruction.format(solution=solution)  


# utilization
def check(name: str, result):
    def is_number(x):
        try:
            float(x)
            return True
        except:
            return False
    
    if not isinstance(result, dict):
        return False

    if name in ["cot", "direct", "multistep", "ensemble"]:
        if not check_json(result, ["answer"]):
            return False
        if not is_number(result["answer"]):
            return False
    elif name == "contract":
        if not check_json(result, ["question"]):
            return False
    elif name == "label":
        if not check_json(result, ["thoughts"]):
            return False
    return True
