# AutoDSL-Translation-Resources

Here is all resources for "Expert-level protocol translation for self-driving labs".

## Pre-processing

See Appx. C.1 for details. 

We use the SpaCy Dependency Parser to analyze the syntactic structure of the protocol, with the specific code available in the `__text_segmentation` method of the `SymbolicCompiler` class in [Ours-SY](https://github.com/PKU-Human-Robot-Integration/AutoDSL-Translation-Resources/blob/main/codebase/stage_1/Ours-SY/symbolic_compiler/compiler.py). The `__autodsl_initwork` method utilizes the `NER` class to accurately identify and classify entities $\text{e}_t \in \mathcal{E}$ within the text. This class comes from [Ours-SY/NER](https://github.com/PKU-Human-Robot-Integration/AutoDSL-Translation-Resources/blob/main/codebase/stage_1/Ours-SY/symbolic_compiler/NER/ner.py). The NER prompt can be found in [NER_prompt](https://github.com/PKU-Human-Robot-Integration/AutoDSL-Translation-Resources/blob/main/codebase/stage_1/Ours-SY/data/ner_prompt.txt).

## Operation dependence synthesis for the syntax level

See Sec. 3.1 for details.

The input (DSL specification) can be found in [AutoDSL](https://github.com/PKU-Human-Robot-Integration/AutoDSL-Translation-Resources/tree/main/codebase/stage_1/Ours-SY/data/autodsl) and [XDL](https://github.com/PKU-Human-Robot-Integration/AutoDSL-Translation-Resources/tree/main/codebase/stage_1/Ours-SY/data/XDL_NL). DSL program synthesis is implemented in the first half of the `optimize_with_constraint` method, which can be found in the `SymbolicCompiler` class in [Ours-SY](https://github.com/PKU-Human-Robot-Integration/AutoDSL-Translation-Resources/blob/main/codebase/stage_1/Ours-SY/symbolic_compiler/compiler.py).

## Reagent flow analysis for the semantic level

See Sec. 3.2 for details.

The output from the syntax level forms the input for the semantic level. The reaching definitions schema is defined in the `compile` method of the `SymbolicCompiler` class. Reagent flow analysis via operation flow traversal is implemented in the `check_before` method, with the first part implementing context transition for `kills` and the second part for `defines`.

## Spatial-temporal dynamics for the execution level

See Sec. 3.3 for details.

The output can be found [here](https://github.com/PKU-Human-Robot-Integration/AutoDSL-Translation-Resources/tree/main/codebase/stage_3/data/translate). In the [Execution level](https://github.com/PKU-Human-Robot-Integration/AutoDSL-Translation-Resources/blob/main/codebase/stage_3/main.py), we implemented model declaration and execution tracing.