/***
 * cpddl
 * -------
 * Copyright (c)2019 Daniel Fiser <danfis@danfis.cz>,
 * Faculty of Electrical Engineering, Czech Technical University in Prague.
 * All rights reserved.
 *
 * This file is part of cpddl.
 *
 * Distributed under the OSI-approved BSD License (the "License");
 * see accompanying file LICENSE for details or see
 * <http://www.opensource.org/licenses/bsd-license.php>.
 *
 * This software is distributed WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the License for more information.
 */

#include "pddl/extarr.h"
#include "pddl/hflow.h"
#include "internal.h"
#include "_heur.h"

struct pddl_heur_flow {
    pddl_heur_t heur;
    pddl_hflow_t flow;
    pddl_extarr_t *cache; // TODO: Refactor and generalize
};
typedef struct pddl_heur_flow pddl_heur_flow_t;

static void heurDel(pddl_heur_t *_h)
{
    pddl_heur_flow_t *h = pddl_container_of(_h, pddl_heur_flow_t, heur);
    _pddlHeurFree(&h->heur);
    pddlHFlowFree(&h->flow);
    pddlExtArrDel(h->cache);
    FREE(h);
}

static int heurEstimate(pddl_heur_t *_h,
                        const pddl_fdr_state_space_node_t *node,
                        const pddl_fdr_state_space_t *state_space)
{
    pddl_heur_flow_t *h = pddl_container_of(_h, pddl_heur_flow_t, heur);
    int *hval = pddlExtArrGet(h->cache, node->id);
    if (*hval == PDDL_COST_MAX)
        *hval = pddlHFlow(&h->flow, node->state, NULL);
    return *hval;
}

pddl_heur_t *pddlHeurFlow(const pddl_fdr_t *fdr, pddl_err_t *err)
{
    if (fdr->has_cond_eff)
        ERR_RET(err, NULL, "Flow heuristic does not support conditional effects.");

    pddl_heur_flow_t *h = ZALLOC(pddl_heur_flow_t);
    pddlHFlowInit(&h->flow, fdr, 0);
    _pddlHeurInit(&h->heur, heurDel, heurEstimate);
    int init = PDDL_COST_MAX;
    h->cache = pddlExtArrNew2(sizeof(int), 1024, 1024 * 1024, NULL, &init);
    return &h->heur;
}

