#pragma once

#ifdef POLICE_Z3

#include "police/expressions/expression_visitor.hpp"

#include <memory>

namespace z3 {
class expr;
}

namespace police {

namespace expressions {
class RawExpression;
class VariableSpace;
} // namespace expressions

class Z3Environment;

class Z3ExpressionAdapter final : public expressions::ExpressionVisitor {
public:
    explicit Z3ExpressionAdapter(Z3Environment* env);

    void visit(const expressions::BinaryFunctionCall& expr) override;
    void visit(const expressions::BinaryFunctionCallGeneric& expr) override;
    void visit(const expressions::Conjunction& expr) override;
    void visit(const expressions::Disjunction& expr) override;
    void visit(const expressions::Comparison& expr) override;
    void visit(const expressions::Constant& expr) override;
    void visit(const expressions::Derivative& expr) override;
    void visit(const expressions::FunctionCall& expr) override;
    void visit(const expressions::IdentifierReference& expr) override;
    void visit(const expressions::IfThenElse& expr) override;
    void visit(const expressions::Negation& expr) override;
    void visit(const expressions::NumericOperation& expr) override;
    void visit(const expressions::Variable& expr) override;

    std::shared_ptr<z3::expr> expression = nullptr;

private:
    z3::expr recurse(const expressions::Expression& expr);

    Z3Environment* env_;
};

} // namespace police

#endif
