#include "police/_bits/z3_model.hpp"

#if POLICE_Z3

#include <z3++.h>

namespace police {

Z3Model::Z3Model(const Z3Environment* env, z3::model* model)
    : model_(model)
    , env_(env)
    , vspace_(&env_->get_variable_space())
{
}

Value Z3Model::get_value(const VariableSpace::value& var) const
{
    auto eval = model_->eval(env_->get_variable(var.id), true);
    return std::visit(
        [&eval](auto&& t) {
            using T = std::decay_t<decltype(t)>;
            if constexpr (std::is_same_v<T, BoolType>) {
                return Value(eval.is_true());
            } else if constexpr (
                std::is_same_v<T, IntegerType> ||
                std::is_same_v<T, BoundedIntType>) {
                return Value(static_cast<int_t>(eval.as_int64()));
            } else {
                return Value(static_cast<real_t>(eval.as_double()));
            }
        },
        var.type);
}

} // namespace police

#endif
