#pragma once

#include <cmath>
#include <cstdint>
#include <limits>
#include <string>

namespace police {

using size_t = std::uint32_t;
using int_t = std::int32_t;
using real_t = double;
using identifier_name_t = std::string;
using ull_t = std::uint64_t;

template <typename T>
constexpr T infinity = std::numeric_limits<T>::infinity();

template <typename T>
constexpr bool is_infinity(T value)
{
    return value == infinity<T>;
}

template <typename T>
constexpr bool is_negative_infinity(T value)
{
    return value == -infinity<T>;
}

namespace number_utils {
constexpr real_t EPSILON = 1e-6;

constexpr bool is_zero(real_t number)
{
    return std::abs(number) < EPSILON;
}

constexpr bool is_greater(real_t a, real_t b)
{
    return a - EPSILON > b;
}

constexpr bool is_greater_equal(real_t a, real_t b)
{
    return a + EPSILON >= b;
}

constexpr bool is_less(real_t a, real_t b)
{
    return a + EPSILON < b;
}

constexpr bool is_less_equal(real_t a, real_t b)
{
    return a - EPSILON <= b;
}

} // namespace number_utils
} // namespace police
