#include "police/cg_policy.hpp"

namespace police::internal {

CGEvaluator::CGEvaluator(std::shared_ptr<cg::Node> node)
    : node_(std::move(node))
{
}

vector<real_t> CGEvaluator::operator()(const vector<real_t>& input) const
{
    const auto out = (*node_)(input);
    vector<real_t> result(out.size());
    for (int i = out.size() - 1; i >= 0; --i) {
        result[i] = out(i);
    }
    return result;
}

} // namespace police::internal
