#pragma once

#include "police/constants.hpp"
#include "police/encoding_information.hpp"
#include "police/linear_condition.hpp"
#include "police/linear_constraint.hpp"

#include <cassert>

namespace police {

struct Outcome;

inline LinearConstraint lower_bound_constraint(size_t x, double val)
{
    LinearConstraint c(LinearConstraint::GREATER_EQUAL);
    c.insert(x, 1.0);
    c.rhs = val;
    return c;
}

inline LinearConstraint upper_bound_constraint(size_t x, double val)
{
    LinearConstraint c(LinearConstraint::LESS_EQUAL);
    c.insert(x, 1.0);
    c.rhs = val;
    return c;
}

inline LinearConstraint less_constraint(size_t x, size_t y)
{
    LinearConstraint c(LinearConstraint::LESS_EQUAL);
    c.insert(x, 1.0);
    c.insert(y, -1.);
    c.rhs = -LP_PRECISION;
    return c;
}

inline LinearConstraint less_equal_constraint(size_t x, size_t y)
{
    LinearConstraint c(LinearConstraint::LESS_EQUAL);
    c.insert(x, 1.0);
    c.insert(y, -1.);
    c.rhs = 0.;
    return c;
}

inline LinearExpression var_expr(size_t var_id, const vector<size_t>& vars)
{
    assert(var_id < vars.size());
    LinearExpression res;
    res.insert(vars[var_id], 1.);
    return res;
}

LinearConstraintConjunction get_assignment_constraints(
    const EncodingInformation& info,
    const Outcome& outcome);

} // namespace police
