#pragma once

#include "police/expressions/expression.hpp"
#include <cassert>

namespace police::expressions {

class Comparison final : public RawExpression {
public:
    enum struct Operator { EQUAL, NOT_EQUAL, LESS, LESS_EQUAL };

    Comparison(Operator op, Expression left, Expression right);

    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;

    bool is_same(const Expression& expr) const override;
    bool operator==(const Comparison& other) const;

    std::size_t hash() const override;

    void dump(std::ostream& out) const override;

    Operator op;
    Expression left;
    Expression right;
};

template <typename Left, typename Right>
bool evaluate(Comparison::Operator op, Left&& left, Right&& right)
{
    switch (op) {
    case Comparison::Operator::EQUAL: return left == right;
    case Comparison::Operator::NOT_EQUAL: return left != right;
    case Comparison::Operator::LESS: return left < right;
    case Comparison::Operator::LESS_EQUAL: return left <= right;
    }
    POLICE_UNREACHABLE();
}

} // namespace police::expressions
