#pragma once

#include "police/expressions/expression_transformer.hpp"
#include "police/expressions/expression_visitor.hpp"
#include "police/expressions/expressions.hpp"
#include "police/expressions/constant_fetcher.hpp"

namespace police::expressions {

class ConstExpressionFolder final : public ExpressionTransformer {
public:
    void visit(Expression& ptr, NumericOperation& expr) override;
    void visit(Expression& ptr, FunctionCall& expr) override;
    void visit(Expression& ptr, BinaryFunctionCall& expr) override;
    void visit(Expression& ptr, Comparison& expr) override;
    void visit(Expression& ptr, Conjunction& expr) override;
    void visit(Expression& ptr, Disjunction& expr) override;
    void visit(Expression& ptr, IfThenElse& expr) override;
    void visit(Expression& ptr, Negation& expr) override;

private:
    ConstantFetcher get_const_;
};

} // namespace police::expressions
