#include "police/expressions/constant_fetcher.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/expressions.hpp"

namespace police::expressions {

std::optional<Value> ConstantFetcher::operator()(const Expression& expr)
{
    expr.accept(*this);
    return value;
}

void ConstantFetcher::visit(const Constant& expr)
{
    value = expr.value;
}

void ConstantFetcher::visit(const BinaryFunctionCall&)
{
    value = std::nullopt;
}

void ConstantFetcher::visit(const Conjunction&)
{
    value = std::nullopt;
}

void ConstantFetcher::visit(const Disjunction&)
{
    value = std::nullopt;
}

void ConstantFetcher::visit(const Comparison&)
{
    value = std::nullopt;
}

void ConstantFetcher::visit(const Derivative&)
{
    value = std::nullopt;
}

void ConstantFetcher::visit(const FunctionCall&)
{
    value = std::nullopt;
}

void ConstantFetcher::visit(const IfThenElse&)
{
    value = std::nullopt;
}

void ConstantFetcher::visit(const Negation&)
{
    value = std::nullopt;
}

void ConstantFetcher::visit(const NumericOperation&)
{
    value = std::nullopt;
}

void ConstantFetcher::visit(const Variable&)
{
    value = std::nullopt;
}

void ConstantFetcher::visit(const IdentifierReference&)
{
    value = std::nullopt;
}

} // namespace police::expressions
