#pragma once

#include "police/expressions/expression_visitor.hpp"
#include "police/storage/value.hpp"

#include <optional>

namespace police::expressions {

class RawExpression;

class ConstantFetcher final : public ExpressionVisitor {
public:
    std::optional<Value> operator()(const Expression& expr);

    void visit(const Constant& expr) override;

    void visit(const BinaryFunctionCall&) override;
    void visit(const Conjunction&) override;
    void visit(const Disjunction&) override;
    void visit(const Comparison&) override;
    void visit(const Derivative&) override;
    void visit(const FunctionCall&) override;
    void visit(const IfThenElse&) override;
    void visit(const Negation&) override;
    void visit(const NumericOperation&) override;
    void visit(const Variable&) override;
    void visit(const IdentifierReference&) override;

    std::optional<Value> value = std::nullopt;
};

} // namespace police::expressions
