#pragma once

#include "police/base_types.hpp"
#include "police/expressions/expression.hpp"

namespace police::expressions {

class Derivative final : public RawExpression {
public:
    explicit Derivative(std::string_view identifier);

    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;

    bool is_same(const Expression&) const override;
    bool operator==(const Derivative& other) const;

    std::size_t hash() const override;

    void dump(std::ostream& out) const override;

    identifier_name_t identifier;
};

} // namespace police::expressions
