#pragma once

#include "police/expressions/expressions.hpp"

namespace police::expressions {

class BinaryFunctionCall;
class BinaryFunctionCallGeneric;
class Conjunction;
class Disjunction;
class Comparison;
class Constant;
class Derivative;
class FunctionCall;
class IdentifierReference;
class IfThenElse;
class Negation;
class NumericOperation;
class Variable;

class ExpressionTransformer {
public:
    virtual ~ExpressionTransformer() = default;
    virtual void visit(Expression& ptr, Constant& expr);
    virtual void visit(Expression& ptr, IdentifierReference& expr);
    virtual void visit(Expression& ptr, Variable& expr);
    virtual void visit(Expression& ptr, NumericOperation& expr);
    virtual void visit(Expression& ptr, FunctionCall& expr);
    virtual void visit(Expression& ptr, BinaryFunctionCall& expr);
    virtual void visit(Expression& ptr, BinaryFunctionCallGeneric& expr);
    virtual void visit(Expression& ptr, Comparison& expr);
    virtual void visit(Expression& ptr, Conjunction& expr);
    virtual void visit(Expression& ptr, Disjunction& expr);
    virtual void visit(Expression& ptr, Negation& expr);
    virtual void visit(Expression& ptr, IfThenElse& expr);
    virtual void visit(Expression& ptr, Derivative& expr);
};

} // namespace police::expressions
