#include "police/expressions/expression_visitor.hpp"
#include "police/expressions/expressions.hpp"
#include <algorithm>

namespace police::expressions {

void ExpressionVisitor::visit(const BinaryFunctionCall& expr)
{
    expr.left.accept(*this);
    expr.right.accept(*this);
}

void ExpressionVisitor::visit(const BinaryFunctionCallGeneric& expr)
{
    expr.left.accept(*this);
    expr.right.accept(*this);
}

void ExpressionVisitor::visit(const Conjunction& expr)
{
    std::for_each(
        expr.children.begin(),
        expr.children.end(),
        [&](auto&& child) { child.accept(*this); });
}

void ExpressionVisitor::visit(const Disjunction& expr)
{
    std::for_each(
        expr.children.begin(),
        expr.children.end(),
        [&](auto&& child) { child.accept(*this); });
}

void ExpressionVisitor::visit(const Comparison& expr)
{
    expr.left.accept(*this);
    expr.right.accept(*this);
}

void ExpressionVisitor::visit(const Constant&)
{
}

void ExpressionVisitor::visit(const Derivative&)
{
}

void ExpressionVisitor::visit(const FunctionCall& expr)
{
    expr.expr.accept(*this);
}

void ExpressionVisitor::visit(const IdentifierReference&)
{
}

void ExpressionVisitor::visit(const IfThenElse& expr)
{
    expr.condition.accept(*this);
    expr.consequence.accept(*this);
    expr.alternative.accept(*this);
}

void ExpressionVisitor::visit(const Negation& expr)
{
    expr.expr.accept(*this);
}

void ExpressionVisitor::visit(const NumericOperation& expr)
{
    expr.left.accept(*this);
    expr.right.accept(*this);
}

void ExpressionVisitor::visit(const Variable&)
{
}

} // namespace police::expressions
