#pragma once

#include "police/expressions/property.hpp"

namespace police::expressions {
class FilterProperty final : public Property {
public:
    enum class Function {
        MIN,
        MAX,
        SUM,
        AVG,
        COUNT,
        FORALL,
        EXISTS,
        ARGMIN,
        ARGMAX,
        VALUES
    };

    FilterProperty(Function fun, PropertyPtr values, PropertyPtr states);

    void accept(ExpressionVisitor& visitor) const override;
    void transform(ExpressionTransformer& transformer) override;

    Function fun;
    PropertyPtr values;
    PropertyPtr states;
};

} // namespace police::expressions
