#pragma once

#include "police/base_types.hpp"
#include "police/expressions/expression.hpp"
#include <cassert>
#include <cmath>

namespace police::expressions {

class FunctionCall final : public RawExpression {
public:
    enum struct Function { FLOOR, CEIL };

    FunctionCall(Function function, Expression expr);

    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;
    bool is_same(const Expression& expr) const override;
    bool operator==(const FunctionCall& other) const;

    std::size_t hash() const override;

    void dump(std::ostream& out) const override;

    Function function;
    Expression expr;
};

template <typename T>
police::int_t evaluate(FunctionCall::Function fn, T&& value)
{
    switch (fn) {
    case police::expressions::FunctionCall::Function::CEIL:
        return std::ceil(static_cast<police::real_t>(value));
    case police::expressions::FunctionCall::Function::FLOOR:
        return std::floor(static_cast<police::real_t>(value));
    }
    // unreachable
    assert(false);
    return 0;
}

} // namespace police::expressions
