#include "police/expressions/ifthenelse.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/expression_transformer.hpp"
#include "police/expressions/expression_visitor.hpp"
#include "police/utils/hash.hpp"
#include <tuple>

namespace police::expressions {

IfThenElse::IfThenElse(
    Expression condition,
    Expression consequence,
    Expression alternative)
    : condition(std::move(condition))
    , consequence(std::move(consequence))
    , alternative(std::move(alternative))
{
}

bool IfThenElse::operator==(const IfThenElse& other) const
{
    return condition.is_same(other.condition) &&
           consequence.is_same(other.consequence) &&
           alternative.is_same(other.alternative);
}

void IfThenElse::dump(std::ostream& out) const
{
    out << condition << " ? " << consequence << " : " << alternative;
}

std::size_t IfThenElse::hash() const
{
    return hash_combine(
        typeid(IfThenElse).hash_code(),
        get_hash(std::tie(condition, consequence, alternative)));
}

__POLICE_IMPLEMENT_EXPR_VISITORS(IfThenElse)
} // namespace police::expressions
