#include "police/expressions/long_run_property.hpp"

namespace police::expressions {

LongRunProperty::LongRunProperty(
    Operator op,
    PropertyPtr expr,
    RewardAccumulation accumulate)
    : op(std::move(op))
    , expr(std::move(expr))
    , accumulate(std::move(accumulate))
{
}

void LongRunProperty::accept(ExpressionVisitor& visitor) const
{
    expr->accept(visitor);
}

void LongRunProperty::transform(ExpressionTransformer& transformer)
{
    expr->transform(transformer);
}

} // namespace police::expressions
