#include "police/expressions/negation.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/expression_transformer.hpp"
#include "police/expressions/expression_visitor.hpp"
#include "police/utils/hash.hpp"

namespace police::expressions {

Negation::Negation(Expression expr)
    : expr(std::move(expr))
{
}

bool Negation::operator==(const Negation& other) const
{
    return expr.base()->is_same(other);
}

void Negation::dump(std::ostream& out) const
{
    out << "!" << expr;
}

std::size_t Negation::hash() const
{
    return hash_combine(typeid(Negation).hash_code(), get_hash(expr));
}

__POLICE_IMPLEMENT_EXPR_VISITORS(Negation)
} // namespace police::expressions
