#include "police/expressions/numeric_operation.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/expression_transformer.hpp"
#include "police/expressions/expression_visitor.hpp"
#include "police/utils/hash.hpp"
#include <tuple>

namespace police::expressions {

NumericOperation::NumericOperation(
    Operand operand,
    Expression left,
    Expression right)
    : operand(std::move(operand))
    , left(std::move(left))
    , right(std::move(right))
{
}

bool NumericOperation::operator==(const NumericOperation& other) const
{
    return operand == other.operand && left.is_same(other.left) &&
           right.is_same(other.right);
}

void NumericOperation::dump(std::ostream& out) const
{
    static const char* ops[] = {"+", "-", "*", "/", "%"};
    out << "(" << left << " " << ops[static_cast<int>(operand)] << " " << right
        << ")";
}

std::size_t NumericOperation::hash() const
{
    return hash_combine(
        typeid(NumericOperation).hash_code(),
        get_hash(static_cast<int>(operand)),
        get_hash(std::tie(left, right)));
}

__POLICE_IMPLEMENT_EXPR_VISITORS(NumericOperation)
} // namespace police::expressions
