#include "police/expressions/path_property.hpp"

namespace police::expressions {

PathProperty::PathProperty(Operator op, PropertyPtr expr)
    : op(op)
    , expr(std::move(expr))
{
}

void PathProperty::accept(ExpressionVisitor& visitor) const
{
    expr->accept(visitor);
}

void PathProperty::transform(ExpressionTransformer& transformer)
{
    expr->transform(transformer);
}

} // namespace police::expressions
