#include "police/expressions/probability_property.hpp"

namespace police::expressions {

ProbabilityProperty::ProbabilityProperty(Operator op, PropertyPtr expr)
    : op(op)
    , expr(std::move(expr))
{
}

void ProbabilityProperty::accept(ExpressionVisitor& visitor) const
{
    expr->accept(visitor);
}

void ProbabilityProperty::transform(ExpressionTransformer& transformer)
{
    expr->transform(transformer);
}

} // namespace police::expressions
