#pragma once

#include "police/expressions/expression.hpp"
namespace police::expressions {

class ExpressionVisitor;
class ExpressionTransformer;
class Property;

using PropertyPtr = std::shared_ptr<Property>;

class Property {
public:
    virtual ~Property() = default;

    virtual void accept(ExpressionVisitor& visitor) const = 0;
    virtual void transform(ExpressionTransformer& transformer) = 0;
};

} // namespace police::expressions
