#include "police/expressions/reward_property.hpp"
#include <algorithm>

namespace police::expressions {

void RewardInstant::accept(ExpressionVisitor& visitor) const
{
    expr.accept(visitor);
    instant.accept(visitor);
}

void RewardInstant::transform(ExpressionTransformer& transformer)
{
    expr.transform(transformer);
    instant.transform(transformer);
}

RewardProperty::RewardProperty(
    Operator op,
    Expression expr,
    RewardAccumulation accumulate,
    PropertyPtr reach,
    std::optional<Expression> step_instant,
    std::optional<Expression> time_instant,
    vector<RewardInstant> reward_instants)
    : op(std::move(op))
    , expr(std::move(expr))
    , accumulate(std::move(accumulate))
    , reach(std::move(reach))
    , step_instant(std::move(step_instant))
    , time_instant(std::move(time_instant))
    , reward_instants(std::move(reward_instants))
{
}

void RewardProperty::accept(ExpressionVisitor& visitor) const
{
    expr.accept(visitor);
    if (reach) reach->accept(visitor);
    if (step_instant.has_value()) step_instant.value().accept(visitor);
    if (time_instant.has_value()) time_instant.value().accept(visitor);
    std::for_each(
        reward_instants.begin(),
        reward_instants.end(),
        [&](auto&& inst) { inst.accept(visitor); });
}

void RewardProperty::transform(ExpressionTransformer& transformer)
{
    expr.transform(transformer);
    if (reach) reach->transform(transformer);
    if (step_instant.has_value()) step_instant.value().transform(transformer);
    if (time_instant.has_value()) time_instant.value().transform(transformer);
    std::for_each(
        reward_instants.begin(),
        reward_instants.end(),
        [&](auto&& inst) { inst.transform(transformer); });
}

} // namespace police::expressions
