#pragma once

#include "police/expressions/property.hpp"
#include "police/storage/vector.hpp"

#include <optional>

namespace police::expressions {

enum class RewardAccumulation {
    STEPS,
    TIME,
    NONE,
};

struct RewardInstant {
    Expression expr;
    RewardAccumulation accumulate;
    Expression instant;

    void accept(ExpressionVisitor& visitor) const;
    void transform(ExpressionTransformer& transformer);
};

class RewardProperty final : public Property {
public:
    enum class Operator { EMIN, EMAX };

    RewardProperty(
        Operator op,
        Expression expr,
        RewardAccumulation accumulate,
        PropertyPtr reach,
        std::optional<Expression> step_instant,
        std::optional<Expression> time_instant,
        vector<RewardInstant> reward_instants);

    void accept(ExpressionVisitor& visitor) const override;
    void transform(ExpressionTransformer& transformer) override;

    Operator op;
    Expression expr;
    RewardAccumulation accumulate;
    PropertyPtr reach;
    std::optional<Expression> step_instant;
    std::optional<Expression> time_instant;
    vector<RewardInstant> reward_instants;
};

} // namespace police::expressions
