#pragma once

#include "police/expressions/property.hpp"
#include "police/expressions/reward_property.hpp"

#include <optional>

namespace police::expressions {

struct PropertyInterval {
    std::optional<Expression> lower = std::nullopt;
    std::optional<Expression> upper = std::nullopt;
    bool lower_exclusive = false;
    bool upper_exclusive = false;

    void accept(ExpressionVisitor& visitor) const;
    void transform(ExpressionTransformer& transformer);
};

struct RewardBound {
    Expression expr;
    RewardAccumulation accumulate;
    PropertyInterval bounds;

    void accept(ExpressionVisitor& visitor) const;
    void transform(ExpressionTransformer& transformer);
};

class UntilProperty final : public Property {
public:
    enum class Operator { UNTIL, WEAK_UNTIL };

    UntilProperty(
        Operator op,
        PropertyPtr left,
        PropertyPtr right,
        PropertyInterval step_bounds = {},
        PropertyInterval time_bounds = {},
        std::vector<RewardBound> bounds = {});

    void accept(ExpressionVisitor& visitor) const override;
    void transform(ExpressionTransformer& transformer) override;

    Operator op;
    PropertyPtr left;
    PropertyPtr right;
    PropertyInterval step_bounds;
    PropertyInterval time_bounds;
    std::vector<RewardBound> bounds;
};

} // namespace police::expressions
