#include "police/expressions/variable.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/expression_transformer.hpp"
#include "police/expressions/expression_visitor.hpp"

namespace police::expressions {

Variable::Variable(police::size_t var_id)
    : var_id(var_id)
{
}

bool Variable::operator==(const Variable& var) const
{
    return var_id == var.var_id;
}

void Variable::dump(std::ostream& out) const
{
    out << "x" << var_id;
}

std::size_t Variable::hash() const
{
    return get_hash(var_id);
}

__POLICE_IMPLEMENT_EXPR_VISITORS(Variable)

} // namespace police::expressions
