#include "police/jani/automaton.hpp"
#include "police/action.hpp"

#include <cassert>

namespace police::jani {

Automaton::Automaton(
    police::size_t id,
    identifier_name_t name,
    vector<identifier_name_t> location_names,
    vector<identifier_name_t> labels,
    vector<police::size_t> initial_locations,
    vector<police::size_t> local_variables)
    : name_(std::move(name))
    , location_names_(std::move(location_names))
    , labels_(std::move(labels))
    , edges_(location_names_.size())
    , initial_locations_(std::move(initial_locations))
    , local_variables_(std::move(local_variables))
    , num_sync_labels_(0)
    , id_(id)
{
}

void Automaton::set_id(police::size_t id) noexcept
{
    id_ = id;
}

void Automaton::set_sync_labels(police::size_t num) noexcept
{
    num_sync_labels_ = num;
}

void Automaton::add_edge(police::size_t location, Edge edge)
{
    if (edge.action == SILENT_ACTION) {
        edges_[location].silent_edges.push_back(std::move(edge));
    } else {
        edges_[location].sync_edges.push_back(std::move(edge));
    }
}

police::size_t Automaton::get_id() const noexcept
{
    return id_;
}

police::size_t Automaton::num_locations() const noexcept
{
    return edges_.size();
}

const vector<Edge>& Automaton::get_sync_edges(police::size_t loc) const noexcept
{
    assert(loc < num_locations());
    return edges_[loc].sync_edges;
}

const vector<Edge>&
Automaton::get_silent_edges(police::size_t loc) const noexcept
{
    assert(loc < num_locations());
    return edges_[loc].silent_edges;
}

const vector<police::size_t>& Automaton::get_initial_locations() const noexcept
{
    return initial_locations_;
}

vector<Edge>& Automaton::get_sync_edges(police::size_t loc) noexcept
{
    assert(loc < num_locations());
    return edges_[loc].sync_edges;
}

} // namespace police::jani
