#pragma once

#include "police/expressions/expression.hpp"
#include "police/jani/automaton.hpp"
#include "police/model.hpp"
#include "police/storage/variable_space.hpp"
#include "police/storage/vector.hpp"

#include <optional>
#include <string_view>

namespace police::jani {

struct SynchronizationParticipant {
    police::size_t automaton;
    police::size_t label;
};

struct SynchronizationVector {
    vector<SynchronizationParticipant> participants;
    police::size_t label;
};

class Model {
public:
    Model(
        VariableSpace variables,
        vector<Automaton> automata,
        vector<SynchronizationVector> syncs,
        vector<expressions::Expression> properties,
        vector<identifier_name_t> action_names,
        vector<identifier_name_t> property_names,
        expressions::Expression initial_state,
        vector<size_t> global_vars) noexcept;

    static Model from_file(std::string_view file_name);

    std::optional<expressions::Expression>
    get_property(std::string_view name) const;

    [[nodiscard]]
    const expressions::Expression& get_initial_state_formula() const
    {
        return initial_state;
    }

    [[nodiscard]]
    const VariableSpace& get_variables() const
    {
        return variables;
    }

    [[nodiscard]]
    const vector<Automaton>& get_automata() const
    {
        return automata;
    }

    [[nodiscard]]
    const vector<SynchronizationVector>& get_syncs() const
    {
        return syncs;
    }

    [[nodiscard]]
    police::Model normalize() const;

    VariableSpace variables;
    vector<Automaton> automata;
    vector<SynchronizationVector> syncs;
    vector<expressions::Expression> properties;
    vector<identifier_name_t> action_names;
    vector<identifier_name_t> property_names;
    vector<size_t> global_vars;
    expressions::Expression initial_state;
};

} // namespace police::jani
