#include "police/jani/parser/automaton.hpp"
#include "police/base_types.hpp"
#include "police/jani/parser/comment.hpp"
#include "police/jani/parser/expression.hpp"
#include "police/jani/parser/language.hpp"
#include "police/jani/parser/schema_factory.hpp"
#include "police/jani/parser/variable.hpp"

namespace police::jani::parser {

JaniSchema<Automaton> automaton_schema()
{
    static JaniSchema<Automaton> schema{};
    static bool initialized = false;
    if (!initialized) {
        auto identifier = JaniString<factories::Construct<identifier_name_t>>{};

        auto transient_value =
            make_dictionary<factories::Construct<TransientValue>>(
                {},
                {comment_element},
                JaniDictArgument(lang::REF, identifier),
                JaniDictArgument(lang::VALUE, expression_schema()));

        auto location = make_dictionary<factories::Construct<Location>>(
            {},
            {comment_element},
            JaniDictArgument(lang::NAME, identifier),
            JaniDictArgument<std::optional<Expression>>(
                lang::TIME_PROGRESS,
                expression_schema(),
                true),
            JaniDictArgument(
                lang::TRANSIENT_VALUES,
                JaniList(transient_value),
                true));

        auto destination = make_dictionary<factories::Construct<Destination>>(
            {},
            {},
            JaniDictArgument(lang::LOCATION, identifier),
            JaniDictArgument<std::optional<Expression>>(
                lang::PROBABILITY,
                make_dictionary(
                    factories::Construct<Expression>(),
                    {comment_element},
                    JaniDictArgument(lang::EXP, expression_schema())),
                true),
            JaniDictArgument(
                lang::ASSIGNMENTS,
                JaniList(make_dictionary(
                    factories::Construct<Assignment>(),
                    {comment_element},
                    JaniDictArgument(
                        lang::REF,
                        JaniString<factories::Construct<identifier_name_t>>()),
                    JaniDictArgument(lang::VALUE, expression_schema()),
                    JaniDictArgument(
                        lang::INDEX,
                        JaniInteger<factories::Construct<int>>(),
                        true))),
                true));

        auto edge = make_dictionary<factories::Construct<Edge>>(
            {},
            {comment_element},
            JaniDictArgument(lang::LOCATION, identifier),
            JaniDictArgument(lang::ACTION, identifier, true),
            JaniDictArgument<std::optional<Expression>>(
                lang::RATE,
                make_dictionary(
                    factories::Construct<Expression>(),
                    {comment_element},
                    JaniDictArgument(lang::EXP, expression_schema())),
                true),
            JaniDictArgument<std::optional<Expression>>(
                lang::GUARD,
                make_dictionary(
                    factories::Construct<Expression>(),
                    {comment_element},
                    JaniDictArgument(lang::EXP, expression_schema())),
                true),
            JaniDictArgument(lang::DESTINATIONS, JaniList(destination)));

        schema = (make_dictionary<factories::Construct<Automaton>>(
            {},
            {comment_element},
            JaniDictArgument(lang::NAME, identifier),
            JaniDictArgument(
                lang::VARIABLES,
                JaniList(variable_schema()),
                true),
            JaniDictArgument<std::optional<Expression>>(
                lang::RESTRICT_INITIAL,
                make_dictionary<factories::Construct<Expression>>(
                    {},
                    {comment_element},
                    JaniDictArgument(lang::EXP, expression_schema())),
                true),
            JaniDictArgument(lang::LOCATIONS, JaniList(location)),
            JaniDictArgument(lang::INITIAL_LOCATIONS, JaniList(identifier)),
            JaniDictArgument(lang::EDGES, JaniList(edge))));

        initialized = true;
    }
    return schema;
}

void visit_all(
    const Automaton& automaton,
    expressions::ExpressionVisitor& visitor)
{
    apply_to_all_expressions(automaton, [&](auto&& expr) {
        expr.accept(visitor);
    });
}

void transform_all(
    Automaton& automaton,
    expressions::ExpressionTransformer& transformer)
{
    apply_to_all_expressions(automaton, [&](auto&& expr) {
        expr.transform(transformer);
    });
}

} // namespace police::jani::parser
