#include "police/jani/parser/composition.hpp"
#include "police/jani/parser/comment.hpp"
#include "police/jani/parser/language.hpp"
#include "police/jani/parser/schema_factory.hpp"

namespace police::jani::parser {

JaniSchema<Composition> composition_schema()
{
    static JaniSchema<Composition> schema{};
    static bool initialized = false;
    if (!initialized) {
        auto identifier_name_tFactory =
            JaniString<factories::Construct<identifier_name_t>>{};

        auto ElementFactory =
            make_dictionary<factories::Construct<CompositionElement>>(
                {},
                {comment_element},
                JaniDictArgument(
                    lang::AUTOMATON,
                    identifier_name_tFactory,
                    false),
                JaniDictArgument(
                    lang::INPUT_ENABLE,
                    JaniList(identifier_name_tFactory),
                    true));

        auto SyncFactory =
            make_dictionary<factories::Construct<Synchronization>>(
                {},
                {comment_element},
                JaniDictArgument(
                    lang::SYNCHRONISE,
                    JaniList(JaniNull(identifier_name_tFactory))),
                JaniDictArgument(lang::RESULT, identifier_name_tFactory, true));

        schema = make_dictionary<factories::Construct<Composition>>(
            {},
            {comment_element},
            JaniDictArgument(lang::ELEMENTS, JaniList(ElementFactory)),
            JaniDictArgument<std::optional<std::vector<Synchronization>>>(
                lang::SYNCS,
                JaniList(SyncFactory),
                true));

        initialized = true;
    }
    return schema;
}

} // namespace police::jani::parser
