#pragma once

#include "police/base_types.hpp"
#include "police/jani/parser/expression.hpp"
#include "police/jani/parser/schema_factory.hpp"
#include "police/jani/parser/types.hpp"

#include <optional>

namespace police::jani::parser {

struct ConstantDeclaration {
    identifier_name_t identifier;
    Type type;
    std::optional<Expression> value = std::nullopt;
};

JaniSchema<ConstantDeclaration> constant_declaration_schema();

} // namespace police::jani::parser
