#include "police/jani/parser/constant_definitions.hpp"

#include <charconv>
#include <string>

namespace police::jani {

void ConstantDefinitions::store(std::string_view identifier, Value value)
{
    defs_.emplace(identifier, value);
}

bool ConstantDefinitions::parse_and_store(
    std::string_view identifier,
    std::string_view value)
{
    if (value == "true") {
        store(identifier, Value{true});
    } else if (value == "false") {
        store(identifier, Value(false));
    } else {
        int val{};
        const auto conv =
            std::from_chars(value.data(), value.data() + value.size(), val);
        if (conv.ptr == value.data() + value.size()) {
            store(identifier, Value(val));
        } else {
            std::size_t idx = -1;
            const real_t dval = std::stod(std::string(value), &idx);
            if (idx < value.size()) {
                return false;
            }
            store(identifier, Value(dval));
        }
    }
    return true;
}

bool ConstantDefinitions::contains(const identifier_name_t& identifier) const
{
    return defs_.contains(identifier);
}

Value ConstantDefinitions::get(const identifier_name_t& identifier) const
{
    assert(contains(identifier));
    return defs_.find(identifier)->second;
}

} // namespace police::jani
