#pragma once

#include "police/base_types.hpp"
#include "police/storage/value.hpp"

#include <cassert>
#include <string_view>

namespace police::jani {

class ConstantDefinitions {
public:
    using const_iterator =
        std::unordered_map<identifier_name_t, Value>::const_iterator;
    using iterator = const_iterator;

    ConstantDefinitions() = default;

    bool parse_and_store(std::string_view identifier, std::string_view value);

    void store(std::string_view identifier, Value value);

    [[nodiscard]]
    bool contains(const identifier_name_t& identifier) const;

    [[nodiscard]]
    Value get(const identifier_name_t& identifier) const;

    [[nodiscard]]
    const_iterator begin() const
    {
        return defs_.begin();
    }

    [[nodiscard]]
    const_iterator end() const
    {
        return defs_.begin();
    }

private:
    std::unordered_map<identifier_name_t, Value> defs_;
};

} // namespace police::jani
