#include "police/jani/parser/jani2nn.hpp"
#include "police/base_types.hpp"
#include "police/jani/parser/schema_factory.hpp"

namespace police::jani::parser {

JaniSchema<JaniPolicyBridge> jani2nn_schema()
{
    static JaniSchema<JaniPolicyBridge> schema{};
    static bool init = false;
    if (!init) {
        schema = make_dictionary(
            factories::Construct<JaniPolicyBridge>(),
            {JaniDictElement(
                 "elements",
                 JaniList(JaniInteger<factories::Discard>())),
             JaniDictElement("file", JaniString<factories::Discard>()),
             JaniDictElement("filter", JaniBool<factories::Discard>())},
            JaniDictArgument(
                "input",
                JaniList(make_dictionary(
                    factories::Construct<AutomatonVariable>(),
                    {},
                    JaniDictArgument(
                        "automaton",
                        JaniNull<identifier_name_t>(
                            JaniString<
                                factories::Construct<identifier_name_t>>())),
                    JaniDictArgument(
                        "name",
                        JaniString<
                            factories::Construct<identifier_name_t>>())))),
            JaniDictArgument(
                "output",
                JaniList(
                    JaniString<factories::Construct<identifier_name_t>>())));

        init = true;
    }
    return schema;
}

std::ostream& operator<<(
    std::ostream& out,
    const police::jani::parser::AutomatonVariable& var)
{
    out << "<" << var.variable << "@"
        << (var.automaton.has_value() ? var.automaton.value() : "null") << ">";
    return out;
}
} // namespace police::jani::parser
