#pragma once

#include "police/base_types.hpp"
#include "police/jani/parser/schema_factory.hpp"
#include "police/storage/vector.hpp"

#include <optional>

namespace police::jani::parser {

struct AutomatonVariable {
    std::optional<identifier_name_t> automaton;
    identifier_name_t variable;
};

struct JaniPolicyBridge {
    vector<AutomatonVariable> input;
    vector<identifier_name_t> output;
};

JaniSchema<JaniPolicyBridge> jani2nn_schema();

std::ostream& operator<<(
    std::ostream& out,
    const police::jani::parser::AutomatonVariable& var);
} // namespace police::jani::parser
