#include "police/jani/parser/model.hpp"
#include "police/jani/parser/automaton.hpp"
#include "police/jani/parser/comment.hpp"
#include "police/jani/parser/composition.hpp"
#include "police/jani/parser/constant_declaration.hpp"
#include "police/jani/parser/expression.hpp"
#include "police/jani/parser/language.hpp"
#include "police/jani/parser/property.hpp"
#include "police/jani/parser/schema_factory.hpp"
#include "police/jani/parser/variable.hpp"

#include <string>

namespace police::jani::parser {

JaniSchema<Model> model_schema()
{
    static JaniSchema<Model> schema{};
    static bool init = false;

    if (!init) {
        auto str = JaniString<factories::Construct<std::string>>();
        schema = (make_dictionary<factories::Construct<Model>>(
            {},
            {},
            JaniDictArgument(
                lang::JANI_VERSION,
                JaniInteger<factories::Construct<int>>()),
            JaniDictArgument(lang::NAME, str),
            JaniDictArgument(
                lang::METADATA,
                make_dictionary(
                    factories::Construct<Metadata>(),
                    {},
                    JaniDictArgument(lang::VERSION, str, true),
                    JaniDictArgument(lang::AUTHOR, str, true),
                    JaniDictArgument(lang::DESCRIPTION, str, true),
                    JaniDictArgument(lang::DOI, str, true),
                    JaniDictArgument(lang::URL, str, true)),
                true),
            JaniDictArgument(
                lang::TYPE,
                JaniEnum<
                    factories::Construct<ModelType>,
                    lang::LTS,
                    lang::DTMC,
                    lang::CTMC,
                    lang::MDP,
                    lang::CTMDP,
                    lang::MA,
                    lang::TA,
                    lang::PTA,
                    lang::STA,
                    lang::HA,
                    lang::PHA,
                    lang::SHA>()),
            JaniDictArgument(
                lang::FEATURES,
                JaniList(JaniEnum<
                         factories::Construct<ModelFeatures>,
                         lang::ARRAYS,
                         lang::DATATYPES,
                         lang::DERIVED_OPERATORS,
                         lang::EDGE_PRIORITIES,
                         lang::FUNCTIONS,
                         lang::HYPERBOLIC_FUNCTIONS,
                         lang::NAMED_EXPRESSIONS,
                         lang::NONDET_SELECTION,
                         lang::STATE_EXIT_REWARDS,
                         lang::TRADEOFF_PROPERTIES,
                         lang::TRIGONOMETRIC_FUNCTIONS>()),
                true),
            JaniDictArgument(
                lang::ACTIONS,
                JaniList(
                    make_dictionary<factories::Construct<identifier_name_t>>(
                        {},
                        {comment_element},
                        JaniDictArgument(lang::NAME, str))),
                true),
            JaniDictArgument(
                lang::CONSTANTS,
                JaniList(constant_declaration_schema()),
                true),
            JaniDictArgument(
                lang::VARIABLES,
                JaniList(variable_schema()),
                true),
            JaniDictArgument<std::optional<Expression>>(
                lang::RESTRICT_INITIAL,
                make_dictionary<factories::Construct<Expression>>(
                    {},
                    {comment_element},
                    JaniDictArgument(lang::EXP, expression_schema())),
                true),
            JaniDictArgument(
                lang::PROPERTIES,
                JaniList(property_schema()),
                true),
            JaniDictArgument(lang::AUTOMATA, JaniList(automaton_schema())),
            JaniDictArgument(lang::SYSTEM, composition_schema())));
        init = true;
    }
    return schema;
}

void visit_all(const Model& model, expressions::ExpressionVisitor& visitor)
{
    apply_to_all_expressions(model, [&](auto&& expr) { expr.accept(visitor); });
}

void transform_all(
    Model& model,
    expressions::ExpressionTransformer& transformer)
{
    apply_to_all_expressions(model, [&](auto&& expr) {
        expr.transform(transformer);
    });
}

} // namespace police::jani::parser
