#include "police/jani/parser/variable.hpp"
#include "police/jani/parser/comment.hpp"
#include "police/jani/parser/expression.hpp"
#include "police/jani/parser/language.hpp"
#include "police/jani/parser/schema_factory.hpp"
#include "police/jani/parser/types.hpp"

#include <string>

namespace police::jani::parser {

JaniSchema<VariableDeclaration> variable_schema()
{
    static auto schema =
        JaniSchema(make_dictionary<factories::Construct<VariableDeclaration>>(
            {},
            {comment_element},
            JaniDictArgument(
                lang::NAME,
                JaniString<factories::Construct<std::string>>{}),
            JaniDictArgument(lang::TYPE, type_schema()),
            JaniDictArgument(
                lang::TRANSIENT,
                JaniBool<factories::Construct<bool>>{},
                true),
            JaniDictArgument<std::optional<Expression>>(
                lang::INITIAL_VALUE,
                expression_schema(),
                true)));
    return schema;
}

} // namespace police::jani::parser
