#pragma once

#include "police/jani/parser/expression.hpp"
#include "police/jani/parser/schema_factory.hpp"
#include "police/jani/parser/types.hpp"

#include <optional>
#include <string>
#include <type_traits>

namespace police::jani::parser {

struct VariableDeclaration {
    std::string identifier;
    Type type;
    bool transient = false;
    std::optional<Expression> initial_value = std::nullopt;
};

template <
    typename F,
    typename Variable_cv,
    std::enable_if_t<
        std::is_same_v<std::remove_cvref_t<Variable_cv>, VariableDeclaration>,
        int> = 0>
void apply_to_all_expressions(Variable_cv&& variable, F fn = F())
{
    if (variable.initial_value.has_value()) {
        fn(variable.initial_value.value());
    }
    apply_to_all_expressions(variable.type, fn);
}

JaniSchema<VariableDeclaration> variable_schema();

} // namespace police::jani::parser
