#include "police/layer_bounds.hpp"

namespace police {

LayerBounds::LayerBounds(size_t size)
    : bounds_(2 * size, 0)
{
}

LayerBounds::LayerBounds(const LinVector& values)
    : bounds_(2 * values.size(), 0)
{
    for (int i = values.size() - 1; i >= 0; --i) {
        bounds_[2 * i] = values[i];
        bounds_[2 * i + 1] = values[i];
    }
}

std::ostream& operator<<(std::ostream& out, const LayerBounds& bounds)
{
    for (size_t i = 0; i < bounds.size(); ++i) {
        out << (i > 0 ? " | " : "") << bounds.lb(i) << " <= x" << i
            << " <= " << bounds.ub(i);
    }
    return out;
}

} // namespace police
