#pragma once

#include "police/lp.hpp"

#include <memory>

namespace police {

class LPFactory {
public:
    virtual ~LPFactory() = default;

    [[nodiscard]]
    std::unique_ptr<LP> make_unique(LPOptimizationKind kind) const
    {
        return std::unique_ptr<LP>(make(kind));
    }

    [[nodiscard]]
    std::shared_ptr<LP> make_shared(LPOptimizationKind kind) const
    {
        return std::shared_ptr<LP>(make(kind));
    }

private:
    [[nodiscard]]
    virtual LP* make(LPOptimizationKind kind) const = 0;
};

} // namespace police
